import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/data/controller/home/home_controller.dart';
import 'package:viser_remit/data/controller/send_money/send_money_controller.dart';
import 'package:viser_remit/view/components/bottom-sheet/bottom_sheet_header_row.dart';
import 'package:viser_remit/view/components/divider/custom_divider.dart';

import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';

class LimitBottomSheet extends StatelessWidget {

  final SendMoneyController controller;

  const LimitBottomSheet({
    super.key,
    required this.controller
  });

  @override
  Widget build(BuildContext context) {

    controller.sendMoneyRepo.apiClient.getGSData().data?.generalSetting;
    var homeController = Get.find<HomeController>();

    return Column(
      children: [
        const BottomSheetHeaderRow(isShowCloseButton: true,header: MyStrings.sendMoneyLimit,bottomSpace: 20),
        Row(
          children: [
            Text(MyStrings.perTransfer.tr,style: mediumLarge.copyWith(color: MyColor.bodyTextColor ),),
            const Spacer(),
            Text("${controller.getPerTransfer()} ${homeController.selectedSendCountry.currency ?? ''}",style: mediumLarge)
          ],
        ),
        const CustomDivider(),
        Row(
          children: [
            Text(MyStrings.dailyLimit.tr,style: mediumLarge.copyWith(color: MyColor.bodyTextColor )),
            const Spacer(),
            Text("${controller.getDailyLimit()} ${homeController.selectedSendCountry.currency ?? ''}",style: mediumLarge,),
          ],
        ),
        const CustomDivider(),
        Row(
          children: [
            Text(MyStrings.availableForToday.tr,style: mediumLarge.copyWith(color: MyColor.bodyTextColor )),
            const Spacer(),
            Text("${controller.getAvailableForTodayAmount()} ${homeController.selectedSendCountry.currency ?? ''}",style: mediumLarge)
          ],
        ),
        const CustomDivider(),
        Row(
          children: [
            Text(MyStrings.monthlyLimit.tr,style: mediumLarge.copyWith(color: MyColor.bodyTextColor )),
            const Spacer(),
            Text("${controller.getMonthlyLimit()} ${homeController.selectedSendCountry.currency ?? ''}",style: mediumLarge,),
          ],
        ),
        const CustomDivider(),
        Row(
          children: [
            Text(MyStrings.availableForThisMonth.tr,style: mediumLarge.copyWith(color: MyColor.bodyTextColor )),
            const Spacer(),
            Text("${controller.getAvailableForThisMonthAmount()} ${homeController.selectedSendCountry.currency ?? ''}",style: mediumLarge),
          ],
        ),
        const CustomDivider(),
      ],
    );
  }
}